﻿using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Marimo.開発支援.ソース生成ライブラリ
{
    /// <summary>
    /// 複数のコード要素を組み合わせたコード要素の基底となります。
    /// </summary>
    public abstract class 組み合わせソースコード : ソースコード
    {
        /// <summary>
        /// 組み合わせソースコードのインスタンスを生成します。
        /// </summary>
        /// <param name="インデント数">親要素からのインデント。</param>
        protected 組み合わせソースコード(int インデント数)
            : base(インデント数)
        {
            コード要素リスト = new List<string>();
        }

        /// <summary>
        /// コード要素を格納しておくリストを取得します。
        /// </summary>
        protected List<string> コード要素リスト { get; private set; }

        /// <summary>
        /// 繰り返しのソースコードを並べ、インデントを考慮してソースを設定します。
        /// </summary>
        /// <param name="空白行を挟む">要素同士の間に一行空行が入る場合はtrue。</param>
        /// <param name="最後に改行">組み合わせたコードの最後に空行が入る場合はtrue。</param>
        protected void ソースを設定する(bool 空白行を挟む, bool 最後に改行)
        {
            if (0 < コード要素リスト.Count)
            {
                ソース =
                    Environment.NewLine +
                    インデント +
                    Regex.Replace(string.Join(
                        Environment.NewLine + (空白行を挟む ? Environment.NewLine : string.Empty),
                        コード要素リスト.ToArray()),
                        @"(?<=\r\n)(?!\r)", インデント);

                if (最後に改行)
                {
                    ソース += Environment.NewLine;
                }
            }
        }
    }
}